function r=updateSTM(skt,hexname)
%function r=updateSTM(skt,hexname)
%
% If using over RS485 - skt sould be IP address only 'i.e. of the form '192.168.1.1'
% and the serial port used should be closed prior to calling this function (with 'clear skt').
%Ian Stothers 30 June 2024
% Updated for DeiceADC12.hex and to give return value
if (nargin<2)
  hexname='c:\temp\DeIceADC12.hex';
endif
if (nargin<1)
  skt.ip='192.168.1.1';
endif

printf('Opening socket\n')
if(exist('skt')==0)
   skt.ip='192.168.1.1';
   ip=skt.ip;
else
  if (ischar(skt))
   ip=skt;
  else
   ip=skt.ip;
  endif
endif
if (ischar(skt))
  skt=sktopen(skt);
endif


printf('Getting old config\n')
config.PartSerno=udpget(skt,'PartSerno');
config.TextPartNo=udpget(skt,'TextPartNo');
config.TextPartNo=config.TextPartNo(1:min(find(config.TextPartNo==0)-1));
if (size(findname(skt.name,"ADC_Scale"))>0)
 config.ADC_Scale=udpget(skt,'ADC_Scale');
endif
if (size(findname(skt.name,"Vcal"))>0)
 config.Vcal=udpget(skt,'Vcal');
endif
if (size(findname(skt.name,"Ical"))>0)
 config.Ical=udpget(skt,'Ical');
endif
if (size(findname(skt.name,"ADC_RC"))>0)
 config.ADC_RC=udpget(skt,'ADC_RC');
endif
if (size(findname(skt.name,"tfoc"))>0)
 config.tfoc=udpget(skt,'tfoc');
endif
if (size(findname(skt.name,"tfsc"))>0)
 config.tfsc=udpget(skt,'tfsc');
endif
if (size(findname(skt.name,"ADC_SR"))>0)
 config.SRate=udpget(skt,'ADC_SR');
endif

config_name=sprintf('config_%d',config.PartSerno);
printf('Saving Config file %s\n',config_name)
save(config_name,'config');

printf('Putting new code on microcontroller\n')
stmprog(hexname)
pause(2)

printf('Reopening socket to microcontroller\n')
ip=skt.ip;
clear skt;
skt=sktopen(ip);



printf('Setting up autorun section on microcontroller\n')
STM32F103_bitfields; % Get some bitfields
setenv('XDG_SESSION_TYPE','x11');

  cfg_n=udpget(skt,'BuildTimeStamp');
  cfg_n=cfg_n(find(cfg_n~=' '));
  cfg_n=cfg_n(find(cfg_n~=':'));

AutoStart=udpget(skt,'AutoStart');
if (AutoStart<1)
  if (exist([cfg_n '.bin'])>0)
   printf(["Using existing config file " cfg_n ".bin   \n"]);
  else
   printf("\nSetting Up ADC\n");
   ADC_Scale = [248.34 0; 0 24];  % from Arlie
   udpset(skt,'ADC_Scale',ADC_Scale);

   udp_capture_start(skt, 'b') ;     %start the config capture
   config.SRate=STM32F103_ADC_SETUP(skt,[1;0],6750000/8); % make 1st channel volts 2nd current
   STM32F103_CC_SETUP_B3(skt);
   udpset(skt,'DoTheDFT',1);
   udpset(skt,'AutoStart',1);
   udpset(skt,'ADC_SR',config.SRate);
   udp_capture_stop;                 % stop the capture
   printf('Programming The Config\n');

   printf(['Saving new config file ' cfg_n '.bin   \n']);

   rename('ConfigLog.bin',[cfg_n '.bin']);    % put the cature file to somewher it won't get auto deleted
  endif
  printf(['Putting Autostart file on device  \n']);

  udp_put_startup(skt,[cfg_n '.bin']);
      printf("Resetting Device\n");
  udpreset(skt);
  pause(3);
  ip=skt.ip;
  clear skt;
  skt=sktopen(ip);


endif

printf('Restoring Config on microcontroller\n')
udpset(skt,'tfoc',config.tfoc);
udpset(skt,'tfsc',config.tfsc);
udpset(skt,'Vcal',config.Vcal);
udpset(skt,'Ical',config.Ical);
udpset(skt,'ADC_Scale',config.ADC_Scale);
udpset(skt,'PartSerno',config.PartSerno);
udpset(skt,'TextPartNo',config.TextPartNo);
udpset(skt,'ADC_SR',config.SRate);

udpprogconfig(skt);
r=1;
clear skt



